return function(Class, Instance)

function Class.rect(rect, radius)
    return Class.new()
        :addRect(rect, radius)
end

function Class.oval(rect)
    return Class.new()
        :addOval(rect)
end

function Class.point(point)
    return Class.new()
        :addSubpath(point)
end

function Class.line(line)
    return Class.new()
        :addSubpath({ x = line.x1, y = line.y1 })
        :addLine({ x = line.x2, y = line.y2 })
end

function Class.arc(arc)
    return Class.new()
        :addSubpath(arc)
        :addArc(arc)
end

local function round(value)
    return value and math.floor(value * 10 + 0.5) / 10
end

function Instance:toSVG()
    local components = self:getComponents()
    local commands = {
        addSubpath = 'M',
        addLine = 'L',
        addCurve = 'C',
        addQuadCurve = 'Q',
        closeSubpath = 'Z',
    }
    for index = 1, #components do
        local component = components[index]
        local command = { commands[component.type] }
        command[#command + 1] = round(component.cx)
        command[#command + 1] = round(component.cy)
        command[#command + 1] = round(component.cx1)
        command[#command + 1] = round(component.cy1)
        command[#command + 1] = round(component.cx2)
        command[#command + 1] = round(component.cy2)
        command[#command + 1] = round(component.x)
        command[#command + 1] = round(component.y)
        components[index] = table.concat(command, ' ')
    end
    return table.concat(components, ' ')
end

end
